#========================================================================
# MAX1000 Board project setup file
# FOR 10M08SAU169C8G
# Sets device, pinout and I/O standards suitable for the MAX1000 board.
#
# Source this file from your project's menu; Tools => Tcl Scripts...
#
#========================================================================

set_global_assignment -name NUM_PARALLEL_PROCESSORS 6

set_global_assignment -name FAMILY "MAX 10"
set_global_assignment -name DEVICE 10M08SAU169C8G
set_global_assignment -name LAST_QUARTUS_VERSION 14.0.0
set_global_assignment -name DEVICE_FILTER_PACKAGE UFBGA
set_global_assignment -name DEVICE_FILTER_PIN_COUNT 169
set_global_assignment -name DEVICE_FILTER_SPEED_GRADE 8

#============================================================
# CLOCK
#============================================================
set_location_assignment PIN_H6 -to CLK12M
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CLK12M

#============================================================
# CLOCK2 (optional)
#============================================================
set_location_assignment PIN_G5 -to CLK_X
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CLK_X

#============================================================
# KEY (RESET and USER BUTTON)
#============================================================
set_location_assignment PIN_E6 -to USER_BTN
set_location_assignment PIN_E7 -to RESET_n
set_instance_assignment -name IO_STANDARD "3.3 V Schmitt Trigger" -to USER_BTN
set_instance_assignment -name IO_STANDARD "3.3 V Schmitt Trigger" -to RESET_n

#============================================================
# USER IO (dual function pin)
#============================================================
set_location_assignment PIN_B1 -to AIN[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[7]

#============================================================
# LED
#============================================================
set_location_assignment PIN_A8  -to LED[0]
set_location_assignment PIN_A9  -to LED[1]
set_location_assignment PIN_A11 -to LED[2]
set_location_assignment PIN_A10 -to LED[3]
set_location_assignment PIN_B10 -to LED[4]
set_location_assignment PIN_C9  -to LED[5]
set_location_assignment PIN_C10 -to LED[6]
set_location_assignment PIN_D8  -to LED[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to LED[7]

#============================================================
# ACCELEROMETER SENSOR
#============================================================
set_location_assignment PIN_J5 -to SEN_INT1
set_location_assignment PIN_L4 -to SEN_INT2
set_location_assignment PIN_J7 -to SEN_SDI
set_location_assignment PIN_K5 -to SEN_SDO
set_location_assignment PIN_J6 -to SEN_SPC
set_location_assignment PIN_L5 -to SEN_CS
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_INT1
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_INT2
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_SDI
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_SDO
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_SPC
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to SEN_CS

#============================================================
# PMOD
#============================================================
set_location_assignment PIN_M3 -to PIO[0]
set_location_assignment PIN_L3 -to PIO[1]
set_location_assignment PIN_M2 -to PIO[2]
set_location_assignment PIN_M1 -to PIO[3]
set_location_assignment PIN_N3 -to PIO[4]
set_location_assignment PIN_N2 -to PIO[5]
set_location_assignment PIN_K2 -to PIO[6]
set_location_assignment PIN_K1 -to PIO[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to PIO[7]

#============================================================
# UART
#============================================================
# TXD of FTDI Chip : BDBUS0
set_location_assignment PIN_A4 -to BDBUS[0]
# RXD of FTDI Chip : BDBUS1
set_location_assignment PIN_B4 -to BDBUS[1]
set_location_assignment PIN_B5 -to BDBUS[2]
set_location_assignment PIN_A6 -to BDBUS[3]
set_location_assignment PIN_B6 -to BDBUS[4]
set_location_assignment PIN_A7 -to BDBUS[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BDBUS[5]

#============================================================
# SDRAM
#============================================================
set_location_assignment PIN_D11 -to DQ[0]
set_location_assignment PIN_G10 -to DQ[1]
set_location_assignment PIN_F10 -to DQ[2]
set_location_assignment PIN_F9  -to DQ[3]
set_location_assignment PIN_E10 -to DQ[4]
set_location_assignment PIN_D9  -to DQ[5]
set_location_assignment PIN_G9  -to DQ[6]
set_location_assignment PIN_F8  -to DQ[7]
set_location_assignment PIN_F13 -to DQ[8]
set_location_assignment PIN_E12 -to DQ[9]
set_location_assignment PIN_E13 -to DQ[10]
set_location_assignment PIN_D12 -to DQ[11]
set_location_assignment PIN_C12 -to DQ[12]
set_location_assignment PIN_B12 -to DQ[13]
set_location_assignment PIN_B13 -to DQ[14]
set_location_assignment PIN_A12 -to DQ[15]
set_location_assignment PIN_E9  -to DQM[0]
set_location_assignment PIN_F12 -to DQM[1]
set_location_assignment PIN_K6  -to A[0]
set_location_assignment PIN_M5  -to A[1]
set_location_assignment PIN_N5  -to A[2]
set_location_assignment PIN_J8  -to A[3]
set_location_assignment PIN_N10 -to A[4]
set_location_assignment PIN_M11 -to A[5]
set_location_assignment PIN_N9  -to A[6]
set_location_assignment PIN_L10 -to A[7]
set_location_assignment PIN_M13 -to A[8]
set_location_assignment PIN_N8  -to A[9]
set_location_assignment PIN_N4  -to A[10]
set_location_assignment PIN_M10 -to A[11]
set_location_assignment PIN_L11 -to A[12]
set_location_assignment PIN_M12 -to A[13]
set_location_assignment PIN_N6  -to BA[0]
set_location_assignment PIN_K8  -to BA[1]
set_location_assignment PIN_M9  -to CLK
set_location_assignment PIN_M8  -to CKE
set_location_assignment PIN_M7  -to RAS_n
set_location_assignment PIN_K7  -to WE_n
set_location_assignment PIN_M4  -to CS_n
set_location_assignment PIN_N7  -to CAS_n
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[8]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[9]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[10]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[11]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[12]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[13]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[14]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQ[15]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQM[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to DQM[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[8]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[9]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[10]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[11]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[12]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to A[13]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BA[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to BA[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CLK
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CKE
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to RAS_n
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to WE_n
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CS_n
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to CAS_n

#============================================================
# FLASH (Optional)
#============================================================
set_location_assignment PIN_B3 -to F_CS
set_location_assignment PIN_A3 -to F_CLK
set_location_assignment PIN_A2 -to F_DI
set_location_assignment PIN_B2 -to F_DO
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to F_CS
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to F_CLK
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to F_DI
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to F_DO

#============================================================
# Arduino Header
#============================================================
set_location_assignment PIN_H8  -to D[0]
set_location_assignment PIN_K10 -to D[1]
set_location_assignment PIN_H5  -to D[2]
set_location_assignment PIN_H4  -to D[3]
set_location_assignment PIN_J1  -to D[4]
set_location_assignment PIN_J2  -to D[5]
set_location_assignment PIN_L12 -to D[6]
set_location_assignment PIN_J12 -to D[7]
set_location_assignment PIN_J13 -to D[8]
set_location_assignment PIN_K11 -to D[9]
set_location_assignment PIN_K12 -to D[10]

# Select with or without pull-up resistors connection for D11 & D12
# without pull-up resistors
set_location_assignment PIN_J10 -to D[11]
set_location_assignment PIN_H10 -to D[12]

#with pull-up resistors
#set_location_assignment PIN_B11 -to D[11]  
#set_location_assignment PIN_G13 -to D[12]

set_location_assignment PIN_H13 -to D[13]
set_location_assignment PIN_G12 -to D[14]

set_location_assignment PIN_E1 -to AIN[0]
set_location_assignment PIN_C2 -to AIN[1]
set_location_assignment PIN_C1 -to AIN[2]
set_location_assignment PIN_D1 -to AIN[3]
set_location_assignment PIN_E3 -to AIN[4]
set_location_assignment PIN_F1 -to AIN[5]
set_location_assignment PIN_E4 -to AIN[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[6]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[7]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[8]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[9]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[10]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[11]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[12]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[13]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to D[14]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[0]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[1]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[2]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[3]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[4]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[5]
set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to AIN[6]

#============================================================
# End of pin and io_standard assignments
#============================================================

# set_global_assignment -name PARTITION_NETLIST_TYPE SOURCE -section_id Top
# set_global_assignment -name PARTITION_FITTER_PRESERVATION_LEVEL PLACEMENT_AND_ROUTING -section_id Top
# set_global_assignment -name PARTITION_COLOR 16764057 -section_id Top

# set_instance_assignment -name PARTITION_HIERARCHY root_partition -to | -section_id Top